local skippedIds = {}
local banCacheIdentifiers = {}
local banInfo = {}
local additionalIdentifiers = {}
local bansOnlyWithAProof = false -- Set this to true if you do  not want to not allow players who are banned without a proof

Citizen.CreateThread(function()
    local skipData = LoadResourceFile(GetCurrentResourceName(), 'skippedids.json')
    skipData = json.decode(skipData)
    if skipData and type(skipData) == 'table' then
        for k, v in pairs(skipData) do
            skippedIds[k] = true
        end
    end
    local addIData = LoadResourceFile(GetCurrentResourceName(), 'additionalIdentifiers.json')
    if addIData and type(addIData) == 'table' then
        for k, v in pairs(addIData) do
            additionalIdentifiers[v] = k
        end
    end
    PerformHttpRequest('https://cdn.globalbanlist.com/bans.json', function(a, b, c)
        b = json.decode(b)
        for k, v in pairs(b) do
            if v.noScreenProof and bansOnlyWithAProof then
            else
                if v.identifiers then
                    for i=1, #v.identifiers do
                        banCacheIdentifiers[v.identifiers[i]] = k
                    end
                end
                banInfo[k] = v.proof
            end
        end
    end)
end)

RegisterCommand('banlist', function(source, args, rawCommand)
    if source ~= 0 then return end
    if not args[1] or not args[2] then return end

    if args[1] == 'skip' then
        skippedIds[args[2]] = true
        SaveResourceFile(GetCurrentResourceName(), 'skippedids.json', json.encode(skippedIds), -1)
        print('[globalbanlist]: ^2The ban ID: '..args[2]..' has been successfully added to the ignore list. Player with this ID will be able to connect altrough he is globally banned.^0')
    elseif args[1] == 'check' then
        if banInfo[args[2]] then
            print('[globalbanlist]: ^2The player has been blacklisted for reason: '..banInfo[args[2]]..'^0')
        else
            print('[globalbanlist]: ^1ID you have provided is not registered in the banlist. Remeber, it is case sensitive.^0')
        end
    end
end)

AddEventHandler('playerConnecting', function(name, setKickReason, deferrals)
    local playerId = source
    Wait(0)
    local shouldSave = false
    local Identifiers = GetPlayerIdentifiers(playerId)
    local banId
    for k, v in pairs(Identifiers) do
        if not v:find('ip:') then
            if banCacheIdentifiers[v] then
                if not banId then banId = banCacheIdentifiers[v] end
                for key, value in pairs(Identifiers) do
                    if not value:find('ip:') then
                        if not banCacheIdentifiers[value] and not additionalIdentifiers[value] then
                            additionalIdentifiers[value] = banId
                            shouldSave = true
                        end
                    end
                end
            end
        end
    end
    for i=0, GetNumPlayerTokens(playerId) - 1 do
        local token = GetPlayerToken(playerId, i)

        if not banId then
            if additionalIdentifiers[token] then
                banId = additionalIdentifiers[token]
                break
            end
        end
    end
    if banId then
        for i=0, GetNumPlayerTokens(playerId) - 1 do
            local token = GetPlayerToken(playerId, i)
            if not additionalIdentifiers[token] then
                additionalIdentifiers[token] = banId
                shouldSave = true
            end
        end
    end

    if shouldSave then
        SaveResourceFile(GetCurrentResourceName(), 'additionalIdentifiers.json', json.encode(additionalIdentifiers), -1)
    end

    if banId and not skippedIds[banId] then
        deferrals.done('You are globally banned by our banlist system. Your ban ID: '..banId)
    else
        deferrals.done()
    end
end)